# Ploting random samples from bivariate normal distributions

# Requires to first install the mvtnorm library
library("mvtnorm")

# mean values for our X, Y variables
means <- c(0, 0)

# Four different covariance matrices that correspond to different
# 1-4: positive correlation values: 0, .3, .5 and .8
cov.mat.1 <- matrix(c(1,0,0,1), nrow=2, ncol=2)
cov.mat.2 <- matrix(c(1,.3,.3,1), nrow=2, ncol=2)
cov.mat.3 <- matrix(c(1,.5,.5,1), nrow=2, ncol=2)
cov.mat.4 <- matrix(c(1,.8,.8,1), nrow=2, ncol=2)

# 5-8: negative correlation values: 0, -.3, -.5 and -.8
cov.mat.5 <- matrix(c(1,0,0,1), nrow=2, ncol=2)
cov.mat.6 <- matrix(c(1,-.3,-.3,1), nrow=2, ncol=2)
cov.mat.7 <- matrix(c(1,-.5,-.5,1), nrow=2, ncol=2)
cov.mat.8 <- matrix(c(1,-.8,-.8,1), nrow=2, ncol=2)

# Random sampling (n = 1000) from bivariate normal distributions
xy.1 <- rmvnorm(1000, mean = means, sigma = cov.mat.1)
xy.2 <- rmvnorm(1000, mean = means, sigma = cov.mat.2)
xy.3 <- rmvnorm(1000, mean = means, sigma = cov.mat.3)
xy.4 <- rmvnorm(1000, mean = means, sigma = cov.mat.4)

xy.5 <- rmvnorm(1000, mean = means, sigma = cov.mat.5)
xy.6 <- rmvnorm(1000, mean = means, sigma = cov.mat.6)
xy.7 <- rmvnorm(1000, mean = means, sigma = cov.mat.7)
xy.8 <- rmvnorm(1000, mean = means, sigma = cov.mat.8)

# Plotting the results
par(mfrow=c(2,4), mar = c(4,4,1,1), pty='s', cex.main = 1.1) # Create a 1x4 grid
plot(xy.1, ylab = "Y", xlab = "X", main = "r = 0", col = 'blue')
plot(xy.2, ylab = "Y", xlab = "X", main = "r = .3", col = 'blue')
plot(xy.3, ylab = "Y", xlab = "X", main = "r = .5", col = 'blue')
plot(xy.4, ylab = "Y", xlab = "X", main = "r = .8", col = 'blue')

plot(xy.5, ylab = "Y", xlab = "X", main = "r = 0", col = 'blue')
plot(xy.6, ylab = "Y", xlab = "X", main = "r = -.3", col = 'blue')
plot(xy.7, ylab = "Y", xlab = "X", main = "r = -.5", col = 'blue')
plot(xy.8, ylab = "Y", xlab = "X", main = "r = -.8", col = 'blue')
